function EqnBC = EqnBC_Darcy_Ex11FastSlowChannels
%% EqnBC: Darcy: Fast and slow channels combined 
% Example on [0,1]^2 with 
%   A fast channel: [0.3,0.7]x[0.6,0.7] w/ permeability=1e2
%   A slow channel: [0.3,0.7]x[0.3,0.4] w/ permeability=1e-2
%   The rest w/ permeability=1 
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  y = pt(:,2);
  Ks = (1e-4)*ones(size(x));
  % For the fast channel 
  fast = find(0.3<=x & x<=0.7 & 0.7<=y & y<=0.8);
  Ks(fast) = 1;
  % For the slow channel 
  slow = find(0.3<=x & x<=0.7 & 0.2<=y & y<=0.3);
  Ks(slow) = 2;
end

% Permeability as a 2x2 full SPD matrix 
function K = fxnK(pt)
  Ks = fxnKs(pt);
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = Ks(:);
  K(:,2,2) = Ks(:);
end

% Source (the right-hand function)
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition
function  pD = fxnpD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  bnd0 = (x==0);
  bnd1 = (x==1);
  pD = 1*bnd0 + 0*bnd1;
end

% Neumann boundary condition
function uN = fxnuN(pt)
  x = pt(:,1);  y = pt(:,2);
  bnd = (y==0 | y==1);
  uN = 0*bnd;
end

% Exact pressure UNKNOWN or just set to zero
function p = fxnp(pt)
  x = pt(:,1);  % y = pt(:,2);
  p = zeros(size(x));
end

% Exact pressure gradient UNKNOWN or just set to zero
function pg = fxnpg(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pg = zeros(size(pt));
end

% Exact velocity UNKNOWN or just set to zero
function u = fxnu(pt) 
  u = zeros(size(pt));
end

end