function EqnBC = EqnBC_Darcy_Ex11CntrLowPerm
%% EqnBC: Darcy: A low permeability region 
% Example on [0,1]^2 w/ a low perm. region [0.3,0.7]x[0.4,0.6] 
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  y = pt(:,2);
  LowPermRgn = (3/10<=x & x<=7/10 & 4/10<=y & y<=6/10);
  Ks = (1e-3)*LowPermRgn + (1e-1)*~LowPermRgn;
end

% Permeability as a 2x2 SPD matrix 
% Permeability as a 2x2 full SPD matrix 
function K = fxnK(pt)
  Ks = fxnKs(pt);
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = Ks(:);
  K(:,2,2) = Ks(:);
end

% Source (the right-hand function)
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition
function pD = fxnpD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  bnd0 = (x==0);
  bnd1 = (x==1);
  pD = 1*bnd0 + 0*bnd1;
end

% Neumann boundary condition
function uN = fxnuN(pt)
  x = pt(:,1);  y = pt(:,2);
  bnd = (y==0 | y==1);
  uN = 0*bnd;
end

% Exact pressure UNKNOWN or just set to zero
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = zeros(size(x));
end

% Exact pressure gradient UNKNOWN or just set to zero
function pg = fxnpg(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pg = zeros(size(pt));
end

% Exact velocity UNKNOWN or just set to zero
function u = fxnu(pt) 
  u = zeros(size(pt));
end

end