function EqnBC = EqnBC_Darcy_Ex10SimpVel
%% EqnBC: Darcy: A very simple example with a known velocity (1,0)  
% James Liu, ColoState; 2012/07--2017/02 

% Velocity vector v=[a,b] 
a = 1;  b = 0;

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  % y = pt(:,2);
  Ks = ones(size(x));
end

% Permeability as a 2x2 SPD matrix 
function K = fxnK(pt)
  % x = pt(:,1);  y = pt(:,2);
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = 1;  
  K(:,2,2) = 1;
end

% Source (the right-hand function)
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition: 
% On the left & right sides 
function pD = fxnpD(pt) 
  x = pt(:,1);  y = pt(:,2);
  % bnd0 = (x==0);
  % bnd1 = (x==1);
  % pD = 1*bnd0 + 0*bnd1;
  pD = 1-a*x-b*y;
end

% Neumann boundary condition: On the bottom and up sides 
% None
% function uN = fxnuN(pt)
%   x = pt(:,1);  y = pt(:,2);
%   bnd = (y==0 | y==1);
%   uN = 0*bnd;
% end

% Known exact "pressure" 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = 1-a*x-b*y;
end

% Known exact "pressure" gradient 
function pg = fxnpg(pt) 
  x = pt(:,1);  y = pt(:,2);
  pg = [a*ones(size(x)), b*ones(size(y))];
end

% Known exact "velocity" 
function u = fxnu(pt) 
  x = pt(:,1);  y = pt(:,2);
  u = -[a*ones(size(x)), b*ones(size(y))];
end

end