function [sln] = Darcy_WG_RectQ0Q0RT0_AsmSlv( ...
  EqnBC, BndryCondType, RectMesh, PermK, GAUSSQUAD)
%% Darcy: WG(Q0,Q0;RT[0]): Assembly & Solving 
% Assuming PermK is an elementwise constant 2x2 matrix 
% James Liu, ColoState; 2012/07--2018/12 

%% Mesh info 
NumEms = RectMesh.NumEms;
NumEgs = RectMesh.NumEgs;
% Assuming RectMesh.flag>=2 

%% Sorting out boundary edges: 1 for Dirichlet, 2 for Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% Boundary info
NumDirichletEgs = size(DirichletEdge,1);
NumNeumannEgs = size(NeumannEdge,1);

%% Auxiliary arrays 
% GMK = zeros(NumEms,4,4);
GMK = Hdiv_RectRT0_NmlzBas_GramMatK(RectMesh,PermK);
% CDWGB = zeros(NumEms,5,4);
CDWGB = WG_RectQ0Q0RT0_CofRT0NmlzBas_DiscWkGradBasFxn(RectMesh);
ArrayEE = zeros(NumEms,1);
ArrayEG = zeros(NumEms,4);
ArrayGG = zeros(NumEms,4,4);
% for i=1:2
%   for j=1:2
%     ArrayEE = ArrayEE + squeeze(GMK(:,i,j).*CDWGB(:,1,i).*CDWGB(:,1,j));
%   end
% end
%% JL20151225: TO BE REVISED FOR EFFECIENCY !!
for ie=1:NumEms
  EltGM = squeeze(GMK(ie,:,:));
  ArrayEE(ie) = squeeze(CDWGB(ie,1,:))' * EltGM * squeeze(CDWGB(ie,1,:));
  for i=1:4
    ArrayEG(ie,i) = squeeze(CDWGB(ie,1,:))' * EltGM * squeeze(CDWGB(ie,1+i,:));
    for j=1:4
      ArrayGG(ie,i,j) = squeeze(CDWGB(ie,1+i,:))' * EltGM * squeeze(CDWGB(ie,1+j,:));
    end
  end
end

%% Setting up the global linear system 
DOFs = NumEms + NumEgs;
% GlbMat = sparse(DOFs,DOFs);
% GlbRHS = zeros(DOFs,1);

%% Assembling the global coefficient matrix GlbMat 
% GlbMat = sparse(DOFs,DOFs);
% Part 1: element-element interaction 
II = (1:NumEms);  JJ = II;
GlbMat = sparse(II,JJ,ArrayEE,DOFs,DOFs);
% Part 2: element-edge interaction 
II = (1:NumEms);
for j=1:4
  JJ = NumEms + RectMesh.elem2edge(:,j);
  GlbMat = GlbMat + sparse(II,JJ,ArrayEG(:,j),DOFs,DOFs);
  GlbMat = GlbMat + sparse(JJ,II,ArrayEG(:,j),DOFs,DOFs);
end
% Part 3: edge-edge interaction 
for i=1:4
  II = NumEms + RectMesh.elem2edge(:,i);
  for j=i:4  % Utilizing symmetry 
    JJ = NumEms + RectMesh.elem2edge(:,j);
    if (j==i) 
      GlbMat = GlbMat + sparse(II,JJ,ArrayGG(:,i,i),DOFs,DOFs);
    else
      GlbMat = GlbMat + sparse(II,JJ,ArrayGG(:,i,j),DOFs,DOFs);
      GlbMat = GlbMat + sparse(JJ,II,ArrayGG(:,i,j),DOFs,DOFs);
    end
  end
end

%% Assembling GlbRHS 
% Applying a Gaussian quadrature on rectangular elements 
GlbRHS = zeros(DOFs,1);
x1 = RectMesh.node(RectMesh.elem(:,1),1);
y1 = RectMesh.node(RectMesh.elem(:,1),2);
x2 = RectMesh.node(RectMesh.elem(:,3),1);
y2 = RectMesh.node(RectMesh.elem(:,3),2);
NumQuadPts = size(GAUSSQUAD.RECT,1);
GAUSSQUADRECT1 = ones(NumQuadPts,2) - GAUSSQUAD.RECT(:,1:2);
qp = zeros(NumEms,2);
for k=1:NumQuadPts
  qp(:,1) = GAUSSQUAD.RECT(k,1)*x1 + GAUSSQUADRECT1(k,1)*x2;
  qp(:,2) = GAUSSQUAD.RECT(k,2)*y1 + GAUSSQUADRECT1(k,2)*y2;
  GlbRHS(1:NumEms) = GlbRHS(1:NumEms) + GAUSSQUAD.RECT(k,3)*EqnBC.fxnf(qp);
end
GlbRHS(1:NumEms) = GlbRHS(1:NumEms) .* RectMesh.area;

%% Incorporating boundary conditions: Neumann as natural 
% Approach I: working on all these edges simultaneously 
if NumNeumannEgs>0
  x1 = RectMesh.node(RectMesh.edge(NeumannEdge,1),1);
  y1 = RectMesh.node(RectMesh.edge(NeumannEdge,1),2);
  x2 = RectMesh.node(RectMesh.edge(NeumannEdge,2),1);
  y2 = RectMesh.node(RectMesh.edge(NeumannEdge,2),2);
  LenNeumannEg = sqrt((x2-x1).^2+(y2-y1).^2);
  % LenNeumannEg = norm(RectMesh.node(RectMesh.edge(NeumannEdge,2),:)...
  %   - RectMesh.node(RectMesh.edge(NeumannEdge,1),:),2);
  NumQuadPts = size(GAUSSQUAD.LINE,1);
  qp = zeros(NumNeumannEgs,2);
  for k=1:NumQuadPts
    qp(:,1) = GAUSSQUAD.LINE(k,1)*x1 + GAUSSQUAD.LINE(k,2)*x2;
    qp(:,2) = GAUSSQUAD.LINE(k,1)*y1 + GAUSSQUAD.LINE(k,2)*y2;
    GlbRHS(NumEms+NeumannEdge) = GlbRHS(NumEms+NeumannEdge)...
      - GAUSSQUAD.LINE(k,3) * EqnBC.fxnuN(qp) .* LenNeumannEg;
  end
end

%% For reducing... 
% disp('Adjusting the global linear system...'); 
flag = zeros(DOFs,1);
flag(NumEms+DirichletEdge) = ones(NumDirichletEgs,1);
EmFreeEg = find(~flag);
sln = zeros(DOFs,1);

%% Incorporating boundary conditions: Dirichlet as essential 
% Approach I: working on all these edges simultaneously 
if NumDirichletEgs>0 
  x1 = RectMesh.node(RectMesh.edge(DirichletEdge,1),1);
  y1 = RectMesh.node(RectMesh.edge(DirichletEdge,1),2);
  x2 = RectMesh.node(RectMesh.edge(DirichletEdge,2),1);
  y2 = RectMesh.node(RectMesh.edge(DirichletEdge,2),2);
  NumQuadPts = size(GAUSSQUAD.LINE,1);
  qp = zeros(NumDirichletEgs,2);
  pDavg = zeros(NumDirichletEgs,1);
  for k=1:NumQuadPts
    qp(:,1) = GAUSSQUAD.LINE(k,1)*x1 + GAUSSQUAD.LINE(k,2)*x2;
    qp(:,2) = GAUSSQUAD.LINE(k,1)*y1 + GAUSSQUAD.LINE(k,2)*y2;
    pDavg = pDavg + GAUSSQUAD.LINE(k,3)*EqnBC.fxnpD(qp);
  end
  sln(NumEms+DirichletEdge) = pDavg;
end

%% Reducing...
GlbRHS = GlbRHS - GlbMat*sln;

%% Solving the reduced global linear system directly 
% disp('Solving the reduced global linear system directly...'); 
sln(EmFreeEg) = GlbMat(EmFreeEg,EmFreeEg) \ GlbRHS(EmFreeEg);

% MatB = GlbMat(EmFreeEg,EmFreeEg);

% %% Solving the full global linear system directly 
% disp('Solving the full global linear system directly...'); 
% % First modifying the global linear system 
% RHS = GlbRHS;
% GlbRHS(NumEms+DirichletEdge) = sln(NumEms+DirichletEdge);
% GM = sparse(DOFs,DOFs);
% GM(EmFreeEg,EmFreeEg) = GlbMat(EmFreeEg,EmFreeEg);
% GM(NumEms+DirichletEdge,NumEms+DirichletEdge) = eye(NumDirichletEgs);
% % Then solving 
% sln  = GM\RHS;

%% JL20130728: TO BE ADDED: SOLVING BY SCHUR COMPLEMENT !
% Note: No interaction across elements, Amm and its inverse are digonal 
% MGM = GlbMat(EmFreeEg,EmFreeEg);  % Squeezed (Modified Global Matrix)
% RHS = GlbRHS(EmFreeEg);  % Squeezed (Modified RHS)
% A11i = spdiags(1./diag(MGM(1:NumEms,1:NumEms)),0,NumEms,NumEms);
% A12 = MGM(1:NumEms,NumEms+1:end); 
% A21 = A12';
% A22 = MGM(NumEms+1:end,NumEms+1:end);
% A = A22 - A21*A11i*A12;
% b1 = RHS(1:NumEms);
% b2 = RHS(NumEms+1,end);
% b = b2 - A21*A11i*b1;
% % Solving lin. sys.: A z = b 
% sln(1:NumEms) = A11i*(b1-A12*z); 
% sln(NumEms+1:end) = z "expanded" 

return;