function [sln,GlbMat,GlbRHS] = Darcy_WG_QuadriQ0Q0RT0_AsmSlv(...
  EqnBC,BndryCondType,QuadriMesh,PermK,GAUSSQUAD)
%% Darcy: WG(Q0,Q0;RT[0]) on a quadrilateral mesh: Assembly & Solving 
% Assuming PermK is an elementwise constant 2x2 SPD matrix 
% James Liu, Zhuoran Wang, ColoState; 2012/07--2018/06 

%% Mesh info 
NumEms = QuadriMesh.NumEms;
NumEgs = QuadriMesh.NumEgs;
% Assuming QuadriMesh.flag>=2 
CofA = QuadriMesh.CofA;
CofB = QuadriMesh.CofB;

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(QuadriMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(QuadriMesh.BndryEdge+1)==2);

%% Boundary info
NumDirichletEgs = size(DirichletEdge,1);
NumNeumannEgs = size(NeumannEdge,1);

%% Auxiliary arrays 
% GMK = zeros(NumEms,4,4);
GMK = Hdiv_QuadriRT0_NmlzBas_GramMatK(QuadriMesh,PermK);
% CDWGB = zeros(NumEms,5,4);
CDWGB = WG_QuadriQ0Q0RT0_CofRT0NmlzBas_DiscWkGradBasFxn(QuadriMesh);
ArrayEE = zeros(NumEms,1);
ArrayEG = zeros(NumEms,4);
ArrayGG = zeros(NumEms,4,4);
%% JL20160517: TO BE REVISED FOR EFFECIENCY !!
for ie=1:NumEms
  EGM = squeeze(GMK(ie,:,:));
  ArrayEE(ie) = squeeze(CDWGB(ie,1,:))' * EGM * squeeze(CDWGB(ie,1,:));
  for i=1:4
    ArrayEG(ie,i) = squeeze(CDWGB(ie,1,:))' * EGM * squeeze(CDWGB(ie,1+i,:));
    for j=1:4
      ArrayGG(ie,i,j) = squeeze(CDWGB(ie,1+i,:))' * EGM * squeeze(CDWGB(ie,1+j,:));
    end
  end
end

%% Setting up the global linear system 
DOFs = NumEms + NumEgs;
% GlbMat = sparse(DOFs,DOFs);
% GlbRHS = zeros(DOFs,1);

%% Assembling the global coefficient matrix GlbMat 
% GlbMat = sparse(DOFs,DOFs);
% Part 1: element-element interaction 
II = (1:NumEms);  JJ = II;
GlbMat = sparse(II,JJ,ArrayEE,DOFs,DOFs);
% Part 2: element-edge interaction 
II = (1:NumEms);
for j=1:4
  JJ = NumEms + QuadriMesh.elem2edge(:,j);
  GlbMat = GlbMat + sparse(II,JJ,ArrayEG(:,j),DOFs,DOFs);
  GlbMat = GlbMat + sparse(JJ,II,ArrayEG(:,j),DOFs,DOFs);
end
% Part 3: edge-edge interaction 
for i=1:4
  II = NumEms + QuadriMesh.elem2edge(:,i);
  for j=i:4  % Utilizing symmetry 
    JJ = NumEms + QuadriMesh.elem2edge(:,j);
    if (j==i) 
      GlbMat = GlbMat + sparse(II,JJ,ArrayGG(:,i,j),DOFs,DOFs);
    else
      GlbMat = GlbMat + sparse(II,JJ,ArrayGG(:,i,j),DOFs,DOFs);
      GlbMat = GlbMat + sparse(JJ,II,ArrayGG(:,i,j),DOFs,DOFs);
    end
  end
end

%% Assembling GlbRHS 
% Applying the chosen Gaussian quadrature for [0,1]^2
GlbRHS = zeros(DOFs,1);
NumQuadPts = size(GAUSSQUAD.RECT,1);
GAUSSQUADRECT1 = ones(NumQuadPts,2) - GAUSSQUAD.RECT(:,1:2);
qp = zeros(NumEms,2);
for k=1:NumQuadPts
  xhat = GAUSSQUADRECT1(k,1);
  yhat = GAUSSQUADRECT1(k,2);
  qp(:,1) = CofA(:,1) + CofA(:,2)*xhat + CofA(:,3)*yhat + CofA(:,4)*xhat*yhat;
  qp(:,2) = CofB(:,1) + CofB(:,2)*xhat + CofB(:,3)*yhat + CofB(:,4)*xhat*yhat;
  jac = (CofB(:,3)+CofB(:,4)*xhat) .* (CofA(:,2)+CofA(:,4)*yhat)...
      - (CofA(:,3)+CofA(:,4)*xhat) .* (CofB(:,2)+CofB(:,4)*yhat);
  GlbRHS(1:NumEms) = GlbRHS(1:NumEms)...
    + GAUSSQUAD.RECT(k,3) * jac .* EqnBC.fxnf(qp);
end

%% Incorporating boundary conditions: Neumann as natural 
% Approach I: working on all these edges simultaneously 
if NumNeumannEgs>0
  x1 = QuadriMesh.node(QuadriMesh.edge(NeumannEdge,1),1);
  y1 = QuadriMesh.node(QuadriMesh.edge(NeumannEdge,1),2);
  x2 = QuadriMesh.node(QuadriMesh.edge(NeumannEdge,2),1);
  y2 = QuadriMesh.node(QuadriMesh.edge(NeumannEdge,2),2);
  LenNeumannEg = sqrt((x2-x1).^2+(y2-y1).^2);
  % BndryLabel = QuadriMesh.BndryEdge(NeumannEdge);
  NumQuadPts = size(GAUSSQUAD.LINE,1);
  qp = zeros(NumNeumannEgs,2);
  for k=1:NumQuadPts
    qp(:,1) = GAUSSQUAD.LINE(k,1)*x1 + GAUSSQUAD.LINE(k,2)*x2;
    qp(:,2) = GAUSSQUAD.LINE(k,1)*y1 + GAUSSQUAD.LINE(k,2)*y2;
    % NEW HERE !
    % GlbRHS(NumEms+NeumannEdge) = GlbRHS(NumEms+NeumannEdge)...
    %   - GAUSSQUAD.LINE(k,3)*EqnBC.fxnuN(qp,BndryLabel).*LenNeumannEg;
    GlbRHS(NumEms+NeumannEdge) = GlbRHS(NumEms+NeumannEdge)...
      - GAUSSQUAD.LINE(k,3) * EqnBC.fxnuN(qp) .* LenNeumannEg;
  end
end

%% For reducing... 
% disp('Adjusting the global linear system...'); 
flag = zeros(DOFs,1);
flag(NumEms+DirichletEdge) = ones(NumDirichletEgs,1);
EmFreeEg = find(~flag);
sln = zeros(DOFs,1);

%% Incorporating boundary conditions: Dirichlet as essential 
% Approach I: working on all these edges simultaneously 
if NumDirichletEgs>0 
  x1 = QuadriMesh.node(QuadriMesh.edge(DirichletEdge,1),1);
  y1 = QuadriMesh.node(QuadriMesh.edge(DirichletEdge,1),2);
  x2 = QuadriMesh.node(QuadriMesh.edge(DirichletEdge,2),1);
  y2 = QuadriMesh.node(QuadriMesh.edge(DirichletEdge,2),2);
  % BndryLabel = QuadriMesh.BndryEdge(DirichletEdge);
  NumQuadPts = size(GAUSSQUAD.LINE,1);
  qp = zeros(NumDirichletEgs,2);
  pDavg = zeros(NumDirichletEgs,1);
  for k=1:NumQuadPts
    qp(:,1) = GAUSSQUAD.LINE(k,1)*x1 + GAUSSQUAD.LINE(k,2)*x2;
    qp(:,2) = GAUSSQUAD.LINE(k,1)*y1 + GAUSSQUAD.LINE(k,2)*y2;
    % NEW HERE !
    % pDavg = pDavg + GAUSSQUAD.LINE(k,3)*EqnBC.fxnpD(qp,BndryLabel);
    pDavg = pDavg + GAUSSQUAD.LINE(k,3)*EqnBC.fxnpD(qp);
  end
  sln(NumEms+DirichletEdge) = pDavg;
end

%% Reducing...
GlbRHS = GlbRHS - GlbMat*sln;

%% Solving the reduced global linear system directly 
sln(EmFreeEg) = GlbMat(EmFreeEg,EmFreeEg) \ GlbRHS(EmFreeEg);

return;