function PermKs = Darcy_SmplnPermSca_TriMesh(fxnKs,TriMesh,GAUSSQUAD)
%% Darcy a triangular mesh: Sampling permeability using a Gaussian quadrature
% PermKs will be an elementwise constant scalar (as averages on elements) 
% James Liu, ColoState; 2012/07--2017/02 

% Basic mesh info 
NumEms = TriMesh.NumEms;

%% 
PermKs = zeros(NumEms,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.TRIG(k,1) * TriMesh.node(TriMesh.elem(:,1),:) ...
     + GAUSSQUAD.TRIG(k,2) * TriMesh.node(TriMesh.elem(:,2),:) ...
     + GAUSSQUAD.TRIG(k,3) * TriMesh.node(TriMesh.elem(:,3),:) ;
  PermKs = PermKs + GAUSSQUAD.TRIG(k,4) * fxnKs(qp);
end

return;