function  err = Darcy_DG_TriP1_Err(EqnBC,TriMesh,PermK,CofNS,GAUSSQUAD)
%% Daryc: DG: TriP1: Computing all kinds of error
% Assuming PermK is an elementwise scalar constant 
% James Liu, ColoState; 2012/07--2016/05 

%% Mesh info 
NumEms = TriMesh.NumEms;
% NumEgs = TriMesh.NumEgs;
% Assuming TriMesh.flag>=2
area = TriMesh.area;

%% All kinds of error 
err = zeros(1,6);

%% Computing error against the exact/true pressure 
% Error in pressure in element interior in L^2-norm 
tmp = zeros(NumEms,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.TRIG(k,1) * TriMesh.node(TriMesh.elem(:,1),:)...
     + GAUSSQUAD.TRIG(k,2) * TriMesh.node(TriMesh.elem(:,2),:)...
     + GAUSSQUAD.TRIG(k,3) * TriMesh.node(TriMesh.elem(:,3),:);
  X = qp(:,1);  Y = qp(:,2);
  NumerPres = CofNS(:,1) + CofNS(:,2).*X + CofNS(:,3).*Y;
  DiffP = abs(EqnBC.fxnp(qp)-NumerPres);
  tmp = tmp + GAUSSQUAD.TRIG(k,4)*(DiffP.^2).*area;
end
err(2) = sqrt(sum(tmp));

% err(2): L^2-norm of numer.pres. vs exact pres. over all elements 
% err(3): L^\infty-norm of numer.pres. vs exact pres. over all elements 

return;