function err = Darcy_CG_TriP1_Err(EqnBC,TriMesh,PermK,sln,GAUSSQUAD)
%% Darcy: CG: TriP1: Computing all errors 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
% Assuming TriMesh.flag>=2 
area = TriMesh.area;

%% All kinds of error 
err = zeros(1,6);
% err(5): L^2-norm of numer.pres. vs exact pres. over all elements 

%% Computing errors against the exact/true pressure 
tmp = zeros(NumEms,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.TRIG(k,1) * TriMesh.node(TriMesh.elem(:,1),:)...
     + GAUSSQUAD.TRIG(k,2) * TriMesh.node(TriMesh.elem(:,2),:)...
     + GAUSSQUAD.TRIG(k,3) * TriMesh.node(TriMesh.elem(:,3),:);
  BaryCrd = TriMesh_BaryCrd(TriMesh,qp);
  NumerPres = sum(BaryCrd(:,1:3).*sln(TriMesh.elem(:,1:3)),2);
  DiffP = abs(EqnBC.fxnp(qp)-NumerPres);
  tmp = tmp + GAUSSQUAD.TRIG(k,4)*(DiffP.^2);
end
err(5) = sqrt(sum(tmp.*area));

return;