// Interface_Silo.cpp
// Interface of DarcyLite+/FemLiteC++ with Silo
// James Liu, ColoState; 2014/07--2016/05

#include <string.h>
#include "silo.h"
#include "BrickMesh.h"


// Writing scalar data on a brick mesh to a silo file

int Write_ScalarData_BrickMesh_Silo(const BrickMesh &mesh,
  char MeshName[], char ScalarName[], double *ScaEm)
{
  DBfile *fp = NULL;  // A pointer to the Silo file
  int DimSz[3];

  DimSz[0] = mesh.nx;
  DimSz[1] = mesh.ny;
  DimSz[2] = mesh.nz;

  // Creating the Silo file
  fp = DBCreate(MeshName, DB_CLOBBER, DB_LOCAL, NULL, DB_PDB);

  // Writing the scalar data (field) to the Silo file
  DBPutQuadvar1(fp, ScalarName, MeshName, ScaEm, DimSz, 3,
                NULL, 0, DB_FLOAT, DB_ZONECENT, NULL);

  // Closing the Silo file
  DBClose(fp);

  return(0);
}


// Writing vector data on a brick mesh to a silo file

int Write_BrickMesh_VectorData_Silo()
{
  return(0);
}


// Writing scalar data on a tetrahedral mesh to a silo file

int Write_TetraMesh_ScalarData_Silo()
{
  return(0);
}


// Writing vector data on a tetrahedral mesh to a silo file

int Write_TetraMesh_VectorData_Silo()
{
  return(0);
}


// Writing scalar data on a rectangular mesh to a silo file

int Write_RectMesh_ScalarData_Silo()
{
  return(0);
}


// Writing vector data on a rectangular mesh to a silo file

int Write_RectMesh_VectorData_Silo()
{
  return(0);
}


// Writing a rectangular mesh to a silo file

int Write_RectMesh_Silo(const RectMesh &mesh)
{
  return(0);
}


// A test function for writing a rectangular mesh to a silo file

int Write_RectMesh_Silo_test()
{
  // Declaring
  DBfile *fp = NULL;
  char filename[64] = "";
  char DimName[2][] = {"",""};
  int DimSz[2];
  float nodex[4];
  float nodey[4];
  float *crd[2];

  // Setting the file name
  strcat(filename, "SmplRectMesh.silo");

  // Setting the dimension names, e.g., "X" and "Y"
  strcat(DimName[0], "X");
  strcat(DimName[1], "Y");

  // Setting the dimension sizes (number of nodes in each dimension)
  DimSz[0] = 4;
  DimSz[1] = 4;
  
  // Setting the "node" coordinates in the "X" direction
  nodex[0] = -1.1;
  nodex[1] = -0.1;
  nodex[2] =  1.3;
  nodex[3] =  1.7;

  // Setting the "node" coordinates in the "Y" direction
  nodey[0] = -2.4;
  nodey[1] = -1.2;
  nodey[2] =  0.4;
  nodey[3] =  0.8;

  // Assembling the array of coordinate arrays
  crd[0] = nodex;
  crd[1] = nodey;

  // Creating a Silo file
  fp = DBCreate(filename, DB_CLOBBER, DB_LOCAL, NULL, DB_PDB);

  // Writing the mesh to the silo file
  DBPutQuadmesh(fp, filename, DimName, crd, DimSz, 2,
                DB_FLOAT, DB_COLLINEAR, NULL);

  // Closing the silo file
  DBClose(fp);

  return(0);
}

// Interface_Silo.cpp