// TetraMesh_ConvCP1toP0.cpp
// TriMesh: Converting CP1 (cont.poly.deg1) to P0 (pcws.const.)
// James Liu, ColoState; 2014/07--2016/05

#include "vector.h"
#include "TetraMesh.h"

int TetraMesh_ConvCP1toP0(Vector &valP0Em, const Vector &valCP1Nd,
                          const TetraMesh &mesh)
{
  int j, k, labele, labelNode[4];
  double sum;

  valP0Em.resize(mesh.numberElements());

  for (labele=1; labele<=mesh.numberElements(); ++labele) {
    mesh.getElementNode(labele, labelNode);
    sum = 0;
    for (j=0; j<4; ++j) {
      k = labelNode[j];
      sum = sum + valCP1Nd(k);
    }
    valP0Em(labele) = 0.25*sum;  // 0.25=1/4;
  }

  return(0);  // if successful
}

// TetraMesh_ConvCP1toP0.cpp