// FE_Tetra_CP13.h
// James Liu, ColoState; 2014/07--2018/02

#include "matrix.h"
#include "vector.h"

#include "cell3d.h"
#include "GaussQuad.h"
#include "mat3.h"
#include "PtVec3d.h"


int FE_Tetra_CP13_BasFxnVal(PtVec3d val[12], const Tetra &tetra, PtVec3d pt);

int FE_Tetra_CP13_BasFxnGrad(Mat3 BasFxnGrad[12], const Tetra &tetra);

int FE_Tetra_CP13_BasFxnDiv(double BasFxnDiv[12], const Tetra &tetra);

int FE_Tetra_CP13_BasFxnStress(Mat3 BasFxnStrs[12], const Tetra &tetra,
                               double lambda, double mu);

FullMatrix FE_Tetra_CP13_EltMatGradGrad(const Tetra &tetra);

FullMatrix FE_Tetra_CP13_EltMatDivDiv(const Tetra &tetra);

Vector FE_Tetra_CP13_IntgrlBasFxnData(const Tetra &tetra, PtVec3d *data,
                                      const GaussQuad &GQTe);

FullMatrix FE_Tetra_CP13_Intrac_RT0NmlzBas(const Tetra &tetra);

// FE_Tetra_CP13.h
