// LinElas3d_WG_HexaQ03Q03RT03Q0_AsmGlbMats.cpp
// Solving linear elasticity in 3d by WG(Q0^3,Q0^3;RT[0]^3,Q0) on a hexa.mesh
// The Schur-complement approach
// James Liu, Graham Harper, ColoState; 2014/07--2017/06

#include "matrix.h"
#include "vector.h"

#include "GaussQuad.h"
#include "PtVec3d.h"
#include "HexaMesh.h"


int LinElas3d_WG_HexaQ03Q03RT03Q0_AsmGlbMats(BlockDiagMatrix &GlbMatEE,
                                             SparseBlockMatrix &GlbMatEC,
                                             SparseBlockMatrix &GlbMatCE,
                                             SparseBlockMatrix &GlbMatCC,
                                             const double lambda,
                                             const double mu,
                                             const HexaMesh &mesh,
                                             const GaussQuad &GQH,
                                             const GaussQuad &GQQ)
{
  int labelElementA, labelElementB, labelFace[6], labelFaceNeighbor[11], sign[6];
  int NumRows, NumColumns, numRowBands, numColumnBands;
  int *dimRowBand, *dimColumnBand, *numBlocksInRowBand, **columnBandIndex;
  
  PtVec3d FcCntrNml, EmCntr, FcCntr;
  Hexa hexa;
  Quadri3d quadri, SQF[6];
  
  // Setup
  int Num0E = mesh.numberElements();
  int Num1C = mesh.numberFaces();
  
  //////////////////////////////////////////////////////////////////////////////
  
  // For GlbMatEE: Element itself interior interaction
  int numBlks = Num0E;
  int *dimBlk = new int[numBlks];
  for (int ie=0; ie<Num0E; ++ie) dimBlk[ie] = 3;
  GlbMatEE.resize(numBlks, dimBlk);
  delete[] dimBlk;
  
  //////////////////////////////////////////////////////////////////////////////
  
  // For GlbMatEC: Element-Face interaction
  NumRows = 3*Num0E;
  NumColumns = 3*Num1C;
  //
  numRowBands = Num0E;
  numColumnBands = Num1C;
  //
  dimRowBand = new int[numRowBands];
  for (int ie=0; ie<Num0E; ++ie)  dimRowBand[ie] = 3;
  //
  dimColumnBand = new int[numColumnBands];
  for (int jc=0; jc<Num1C; ++jc)  dimColumnBand[jc] = 3;
  //
  numBlocksInRowBand = new int[numRowBands];
  columnBandIndex = new int*[numRowBands];
  //
  // Setting up GlbMatEC: the sparsity structure
  for (int le=0; le<Num0E; ++le) {
    int labele = le + mesh.beginLabelElement();
    mesh.getElementFace(labele, labelFace);
    numBlocksInRowBand[le] = 6;
    columnBandIndex[le] = new int[numBlocksInRowBand[le]];
    for (int j=0; j<6; ++j)
      columnBandIndex[le][j] = labelFace[j];
  }
  //
  // Setting up GlbMatEC: resize
  GlbMatEC.resize(numRowBands, numColumnBands, dimRowBand, dimColumnBand,
                  numBlocksInRowBand, columnBandIndex);
  //
  // Releasing
  for (int i=0; i<numRowBands; ++i)  delete[] columnBandIndex[i];
  delete[] columnBandIndex;
  delete[] numBlocksInRowBand;
  delete[] dimRowBand, dimColumnBand;
  
  //////////////////////////////////////////////////////////////////////////////
  
  // For GlbMatCE: Face-Element(interior) interaction
  NumRows = 3*Num1C;
  NumColumns = 3*Num0E;
  //
  numRowBands = Num1C;
  numColumnBands = Num0E;
  //
  dimRowBand = new int[numRowBands];
  for (int i=0; i<numRowBands; ++i)  dimRowBand[i] = 3;
  //
  dimColumnBand = new int[numColumnBands];
  for (int j=0; j<numColumnBands; ++j)  dimColumnBand[j] = 3;
  //
  numBlocksInRowBand = new int[numRowBands];
  columnBandIndex = new int*[numRowBands];
  //
  // Setting up GlbMatCE: the sparsity structure
  for (int lc=0; lc<Num1C; ++lc) {
    int labelc = lc + mesh.beginLabelFace();
    mesh.getFaceElement(labelc, labelElementA, labelElementB);
    if (mesh.isBoundaryFace(labelc)==0) {  // An interior face
      numBlocksInRowBand[lc] = 2;  // 2 adjacent elements
      columnBandIndex[lc] = new int[numBlocksInRowBand[lc]];
      columnBandIndex[lc][0] = labelElementA;
      columnBandIndex[lc][1] = labelElementB;
    }
    if (mesh.isBoundaryFace(labelc)>0) {  // A boundary face
      numBlocksInRowBand[lc] = 1;  // 1 adjacent element
      columnBandIndex[lc] = new int[numBlocksInRowBand[lc]];
      columnBandIndex[lc][0] = labelElementA;
    }
  }
  // Setting up GlbMatCE: resize
  GlbMatCE.resize(numRowBands, numColumnBands, dimRowBand, dimColumnBand,
                  numBlocksInRowBand, columnBandIndex);
  //
  // Releasing
  for (int i=0; i<numRowBands; ++i)  delete[] columnBandIndex[i];
  delete[] columnBandIndex;
  delete[] numBlocksInRowBand;
  delete[] dimRowBand, dimColumnBand;
  
  //////////////////////////////////////////////////////////////////////////////
  
  // For GlbMatCC: Face-Face interaction
  NumRows = 3*Num1C;
  NumColumns = NumRows;
  //
  numRowBands = Num1C;
  numColumnBands = numRowBands;
  //
  dimRowBand = new int[numRowBands];
  for (int ic=0; ic<Num1C; ++ic)  dimRowBand[ic] = 3;
  //
  dimColumnBand = new int[numColumnBands];
  for (int jc=0; jc<Num1C; ++jc)  dimColumnBand[jc] = 3;
  //
  numBlocksInRowBand = new int[numRowBands];
  columnBandIndex = new int*[numRowBands];
  //
  // Setting up GlbMatCC: the sparsity structure
  for (int lc=0; lc<Num1C; ++lc) {
    int labelc = lc + mesh.beginLabelFace();
    mesh.getFaceFace(labelc, labelFaceNeighbor);
    if (mesh.isBoundaryFace(labelc)==0) {
      numBlocksInRowBand[lc] = 11;  // 11 adjacent faces
      columnBandIndex[lc] = new int[numBlocksInRowBand[lc]];
      for (int j=0; j<11; ++j)
        columnBandIndex[lc][j] = labelFaceNeighbor[j];
    }
    if (mesh.isBoundaryFace(labelc)>0) {
      numBlocksInRowBand[lc] = 6;  // 6 adjacent faces
      columnBandIndex[lc] = new int[numBlocksInRowBand[lc]];
      for (int j=0; j<6; ++j)
        columnBandIndex[lc][j] = labelFaceNeighbor[j];
    }
  }
  //
  // Setting up GlbMatCC: resize
  GlbMatCC.resize(numRowBands, numColumnBands, dimRowBand, dimColumnBand,
                  numBlocksInRowBand, columnBandIndex);
  //
  // Releasing
  for (int i=0; i<numRowBands; ++i)  delete[] columnBandIndex[i];
  delete[] columnBandIndex;
  delete[] numBlocksInRowBand;
  delete[] dimRowBand, dimColumnBand;
  
  //////////////////////////////////////////////////////////////////////////////
  
  // Preparation for assembly
  FullMatrix EltMat(21,21), SubMat(3,3), ESSM(21,21), EDDM(21,21);
  
  // Assembling the global matrix
  std::cout << "le/1000= ";
  for (int le=0; le<Num0E; ++le) {
    if (le%1000==0)  std::cout << le/1000 << "  " << std::flush;
    int labele = le + mesh.beginLabelElement();
    mesh.getElementFace(labele, labelFace);
    hexa = mesh.element(labele);
    hexa.enrich();
    double diam = hexa.diameter();
    
    for (int j=0; j<6; ++j)  SQF[j] = mesh.face(labelFace[j]);
    
    // Determining signs by using centers and normals
    EmCntr = hexa.trilinearmapping(0.5, 0.5, 0.5);
    for (int j=0; j<6; ++j) {
      sign[j] = 1;
      quadri = SQF[j];
      FcCntr = quadri.bilinearmapping(0.5, 0.5);
      FcCntrNml = quadri.normal(0.5, 0.5);
      if (dotProduct(FcCntrNml,FcCntr-EmCntr)<0)  sign[j] = -1;
    }
    
    // Compute the element matrix
    ESSM = WG3d_HexaQ03Q03RT03Q0_NmlBas_EltStrnStrnMat(hexa, SQF, sign, GQH, GQQ);
    EDDM = WG3d_HexaQ03Q03RT03Q0_NmlBas_EltDivDivMat(hexa, SQF, sign, GQH, GQQ);
    EltMat = (2*mu)*ESSM + lambda*EDDM;
    
    // For element interior interaction
    SubMat = submatrix(EltMat, 1, 1, 3, 3);
    GlbMatEE.setBlock(labele, SubMat);
    
    // For element(interior)-face interaction
    for (int j=0; j<6; ++j) {
      SubMat = submatrix(EltMat, 1, 3*j+4, 3, 3);
      GlbMatEC.addBlock(labele, labelFace[j], SubMat);
      SubMat = submatrix(EltMat, 3*j+4, 1, 3, 3);
      GlbMatCE.addBlock(labelFace[j], labele, SubMat);
    }
    
    // For face-face interaction
    for (int i=0; i<6; ++i) {
      //int ib = labelFace[i-1];
      for (int j=0; j<6; ++j) {
        //int jb = labelFace[j-1];
        SubMat = submatrix(EltMat, 3*i+4, 3*j+4, 3, 3);
        GlbMatCC.addBlock(labelFace[i], labelFace[j], SubMat);
        // GlbMatCC.addBlock(jb, ib, SubMat);
      }
    }
  }
  // std::cout << "\n";
  
  return(0);  // If successful
}

// LinElas3d_WG_HexaQ03Q03RT03Q0_AsmGlbMats.cpp
