// LinElas3d_WG_HexaMesh.cpp
// James Liu, Graham Harper, ColoState; 2014/07--2017/11

#include "matrix.h"
#include "vector.h"

#include "GaussQuad.h"
#include "PtVec3d.h"
#include "HexaMesh.h"


////////////////////////////////////////////////////////////////////////////////
// Solving linear elasticity in 3d by WG(P0^3,P0^3;AT0^3,P0) on a hexa.mesh
// See ...
////////////////////////////////////////////////////////////////////////////////
/*
// The Schur-complement approach: 4 functions
#include "LinElas3d_WG_HexaP03P03AT03P0_AsmBndryConds.cpp"
#include "LinElas3d_WG_HexaP03P03AT03P0_AsmGlbMats.cpp"
#include "LinElas3d_WG_HexaP03P03AT03P0_AsmSource.cpp"
#include "LinElas3d_WG_HexaP03P03AT03P0_ModiLinSys.cpp"

// Common functions
#include "LinElas3d_WG_HexaP03P03AT03P0_DsplStrsDiv.cpp"
#include "LinElas3d_WG_HexaP03P03AT03P0_Err.cpp"
*/

////////////////////////////////////////////////////////////////////////////////
// Solving linear elasticity in 3d by WG(Q0^3,Q0^3;RT0^3,Q0) on a hexa.mesh
// See ...
////////////////////////////////////////////////////////////////////////////////

// The single-matrix approach: 4 functions
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_AsmBndryConds1.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_AsmGlbMat1.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_AsmSource1.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_ModiLinSys1.cpp"

// The Schur-complement approach: 4 functions
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_AsmBndryConds.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_AsmGlbMats.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_AsmSource.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_ModiLinSys.cpp"
 
// Common functions
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_DsplStrsDiv.cpp"
#include "LinElas3d_WG_HexaQ03Q03RT03Q0_Err.cpp"


////////////////////////////////////////////////////////////////////////////////
// Solving linear elasticity in 3d by WG(P1^3,Prm;P0^{3x3},P0) on a hexa.mesh
// Stabilization needed
// See WangWangWangZhang_JCAM_2016
////////////////////////////////////////////////////////////////////////////////

// The single-matrix approach: 4 functions with suffix "1"
/*
#include "LinElas3d_WG_HexaP13PrmP033P0_AsmBndryConds1.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_AsmGlbMat1.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_AsmSource1.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_ModiLinSys1.cpp"
*/

// The Schur-complement approach: 4 functions
#include "LinElas3d_WG_HexaP13PrmP033P0_AsmBndryConds.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_AsmGlbMats.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_AsmSource.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_ModiLinSys.cpp"

// Common functions
#include "LinElas3d_WG_HexaP13PrmP033P0_DsplStrsDiv.cpp"
#include "LinElas3d_WG_HexaP13PrmP033P0_Err.cpp"

// LinElas3d_WG_HexaMesh.cpp
