// LinElas3d_CG_TetraP13_AsmBndryConds.cpp
// James Liu, ColoState; 2014/07--2018/02

#include "vector.h"

#include "cell3d.h"
#include "GaussQuad.h"
#include "mat3.h"
#include "PtVec3d.h"
#include "TetraMesh.h"
#include "FE_Tetra_CP13.h"


// JL20160901: TO BE REVISED TO INCORPORATE Neumann bndry.cond.

int LinElas3d_CG_TetraP13_AsmBndryConds(Vector &GlbVecDirichlet,
                                        Vector &GlbVecNeumann,
                                        PtVec3d (*fxnuD)(PtVec3d),
                                        const TetraMesh &mesh,
                                        const GaussQuad &GQT)
{
  // Setup
  int DOFs = 3*mesh.numberNodes();
  GlbVecDirichlet.resize(DOFs);

  // Assembling Dirichlet boundary conditions
  // Just interpolation or evaluation of the given boundary-value function
  for (int labeld=1; labeld<=mesh.numberNodes(); ++labeld) {
    if (mesh.isBoundaryNode(labeld)>0) {
      int ld = labeld - 1;
      PtVec3d pt = mesh.node(labeld);
      PtVec3d uD = fxnuD(pt);
      GlbVecDirichlet(3*ld+1) = uD.xCrd();
      GlbVecDirichlet(3*ld+2) = uD.yCrd();
      GlbVecDirichlet(3*ld+3) = uD.zCrd();
    }
  }

  // Assembling Neumann boundary conditions
  GlbVecNeumann.resize(DOFs);

  return(0);  // If successful
}

// LinElas3d_CG_TetraP13_AsmBndryConds.cpp
