// LinElas3d_CG_TetraP13.h
// Solving linear elasticity by CG P1^3 elements on tetrahedral meshes
// James Liu, ColoState; 2014/07--2018/02

#ifndef LinElas3d_CG_TetraP13_H
#define LinElas3d_CG_TetraP13_H

#include "matrix.h"
#include "vector.h"

#include "GaussQuad.h"
#include "PtVec3d.h"
#include "TetraMesh.h"

//////////////////////////////////////////////////////////////
// For continuous Galerkin P1^3 elements on tetrahedral meshes
//////////////////////////////////////////////////////////////

int LinElas3d_CG_TetraP13_AsmBndryConds(Vector &DirichletBndryVec,
                                        Vector &NeumannBndryVec,
                                        PtVec3d (*fxnuD)(PtVec3d),
                                        const TetraMesh &mesh,
                                        const GaussQuad &GQT);

int LinElas3d_CG_TetraP13_AsmGlbMat(SparseBlockMatrix &GlbMat,
                                    double lambda, double mu,
                                    const TetraMesh &mesh);

int LinElas3d_CG_TetraP13_AsmSource(Vector &GlbVecSource,
                                    PtVec3d (*fxnf)(PtVec3d),
                                    const TetraMesh &mesh,
                                    const GaussQuad &GQTe);

int LinElas3d_CG_TetraP13_DsplDivStrs(PtVec3d *DsplEm, double *DivEm,
                                      Mat3 *StrsEm, double lambda, double mu,
                                      const TetraMesh &mesh, Vector &sln);

int LinElas3d_CG_TetraP13_Err(double &L2ErrDspl, double &L2ErrStrs,
                              double lambda, double mu,
                              PtVec3d (*fxnu)(PtVec3d),
                              Mat3 (*fxnsigma)(PtVec3d), Vector &sln,
                              const TetraMesh &mesh, const GaussQuad &GQTe);

int LinElas3d_CG_TetraP13_IntpltDspl(PtVec3d *IntpltDspl,
                                     PtVec3d (*fxnu)(PtVec3d),
                                     const TetraMesh &mesh);

int LinElas3d_CG_TetraP13_ModiLinSys(SparseBlockMatrix &GlbMat, Vector &GlbRHS,
                                     const TetraMesh &mesh,
                                     const Vector &GlbVecSource,
                                     const Vector &GlbVecDirichletBC,
                                     const Vector &GlbVecNeumannBC);

int LinElas3d_CG_TetraP13_ProjDsplDivStrs(PtVec3d *DsplEmAvg, Vector &DivEmAvg,
                                          double lambda, double mu,
                                          PtVec3d (*fxnu)(PtVec3d),
                                          double (*fxndivu)(PtVec3d),
                                          Mat3 (*fxnsigma)(PtVec3d),
                                          const TetraMesh &mesh,
                                          const GaussQuad &GQTe);

#endif  // LinElas3d_CG_TetraP13_H
// LinElas3d_CG_TetraP13.h
