// WG3d_Brick.h
// James Liu, ColoState; 2014/07--2016/05

// Brick: Coordinates (x0,y0,z0), (x1,y1,z1)

#ifndef WG3D_BRICK_H
#define WG3D_BRICK_H

#include "matrix.h"
#include "PtVec3d.h"
#include "cell3d.h"


////////////////////////////////////////////////////////////////////////////////

// WG3d: Brick(Q0,Q0,RT[0]): Element mass matrix (actually just a number)
void WG3d_BrickQ0Q0RT0_EltMassMat(
  double x0, double y0, double z0,
  double x1, double y1, double z1,
  double &EMM);

// WG3d: Brick(Q0,Q0,RT[0]): Coeff. of disc.wk.grad. in RT[0] nmlz.bas.
void WG3d_BrickQ0Q0RT0_CofDiscWkGrad_NmlzBas(
  double x0, double y0, double z0,
  double x1, double y1, double z1,
  double CDWG[][6]);

// WG3d: Brick(Q0,Q0,RT[0]): Element grad-grad matrix
void WG3d_BrickQ0Q0RT0_EltGradGradMat(double EGGM[][7],
  double x0, double y0, double z0,
  double x1, double y1, double z1);

////////////////////////////////////////////////////////////////////////////////

// WG3d: Brick(Q0,Q0,RT[0]): Coeff. of disc.wk.grad. in RT[0] nmlz.bas.
FullMatrix WG3d_Brick0_CofDiscWkGrad_NmlzBas(const Brick &brick);

// WG3d: Brick(Q0,Q0,RT[0]): Element grad-grad matrix
FullMatrix WG3d_Brick0_EltGradGradMatK(const Brick &brick, Mat3 &MatK);

// WG3d: Brick(Q0,Q0,RT[0]): Normal fluxes of 7 WG basis functions
FullMatrix WG3d_Brick0_NmlFluxK_NmlzBas_Proj(const Brick &brick, Mat3 &MatK);

////////////////////////////////////////////////////////////////////////////////

// WG3d: Brick1(Q0,Q1,P1^3): Coeff.disc.wk.grad. in nmlz.bas.: matrix 12-by-25
// 12 nmlz.bas.fxns as rows;  25 WG bas.fxns. as columns
FullMatrix WG3d_Brick1_CofDiscWkGrad_NmlzBas(const Brick &brick,
                                             Rect3d SRF[6], int sign[6],
                                             const GaussQuad &GQB,
                                             const GaussQuad &GQR);

// WG3d: Brick1(Q0,Q1,P1^3): Element grad-grad matrix w/ permeability MatK: 25*25
FullMatrix WG3d_Brick1_EltGradGradMatK(const Brick &brick, Mat3 MatK,
                                       Rect3d SRF[6], int sign[6],
                                       const GaussQuad &GQB,
                                       const GaussQuad &GQR);

// WG3d: Brick1(Q0,Q1,P1^3): 6*25
FullMatrix WG3d_Brick1_NmlFluxK_NmlzBas(const Brick &brick, Mat3 &MatK,
                                        Rect3d SRF[6], int sign[6],
                                        const GaussQuad &GQB,
                                        const GaussQuad &GQR);

#endif  // WG3D_BRICK_H

// WG3d_Brick.h