// Darcy3d_WG_TetraP0P0RT0_AsmSource.cpp
// The Schur-complement approach
// James Liu, Graham Harper, ColoState; 2014/07--2017/03

#include "vector.h"

#include "cell3d.h"
#include "GaussQuad.h"
#include "TetraMesh.h"
#include "PtVec3d.h"


int Darcy3d_WG_TetraP0P0RT0_AsmSource(Vector &GlbVecE, double (*fxnf)(PtVec3d),
                                      const TetraMesh &mesh,
                                      const GaussQuad &GQTe)
{
  int i, j, labele, le;
  double ftmp, fval, vol;
  PtVec3d qp;
  Tetra tetra;

  // Setup
  int Num0E = mesh.numberElements();
  GlbVecE.resize(Num0E);

  // Assembling GlbVecE
  for (int labele=1; labele<=Num0E; ++labele) {
    tetra = mesh.element(labele);
    vol = tetra.volume();
    ftmp = 0;
    for (i=0; i<GQTe.numberQuadraturePoints(); ++i) {
      qp = PtVec3d(0,0,0);
      for (j=0; j<GQTe.numberVertices(); ++j) {
        qp = qp + GQTe.baryCoordinate(i,j) * tetra.vertex(j);
      }
      fval = fxnf(qp);
      ftmp += GQTe.weight(i) * fval;
    }
    GlbVecE(labele) = ftmp * vol;
  }

  return(0);  // If successful
}