// Darcy3d_WG_TetraMesh.cpp
// James Liu, Graham Harper, ColoState; 2014/07--2018/05

////////////////////////////////////////////////////////////////////////////////
// For solving Darcy in 3d by the lowest order WG(P0,P0;RT0)Tetra elements
////////////////////////////////////////////////////////////////////////////////

// The single-matrix approach: 4 functions with suffix "1"
#include "Darcy3d_WG_TetraP0P0RT0_AsmBndryConds1.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_AsmGlbMat1.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_AsmSource1.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_ModiLinSys1.cpp"
// The Schur-complemnt approach: 4 functions
#include "Darcy3d_WG_TetraP0P0RT0_AsmBndryConds.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_AsmGlbMats.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_AsmSource.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_ModiLinSys.cpp"
// Common functions
#include "Darcy3d_WG_TetraP0P0RT0_PresVelFlux.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_ProjPres.cpp"
#include "Darcy3d_WG_TetraP0P0RT0_Err.cpp"

////////////////////////////////////////////////////////////////////////////////
// For solving Darcy in 3d by WG(P1,P0;P0^3)Tetra elements with stabilizer
////////////////////////////////////////////////////////////////////////////////

// The single-matrix approach: 4 functions with suffix "1"
/*
#include "Darcy3d_WG_TetraP1P0P03_AdjLinSys1.cpp"
#include "Darcy3d_WG_TetraP1P0P03_AsmBndryConds1.cpp"
#include "Darcy3d_WG_TetraP1P0P03_AsmGlbMat1.cpp"
#include "Darcy3d_WG_TetraP1P0P03_AsmSource1.cpp"
*/
// The Schur-complement approach
/*
#include "Darcy3d_WG_TetraP1P0P03_AsmBndryConds.cpp"
#include "Darcy3d_WG_TetraP1P0P03_AsmGlbMats.cpp"
*/

// Common functions
/*
#include "Darcy3d_WG_TetraP1P0P03_ProjPresVel.cpp"
*/

////////////////////////////////////////////////////////////////////////////////
