// JL20141030: TO BE REVISED
// Darcy3d_SmplnPerm_TetraMesh.cpp
// Darcy3d: Sampling permeability on a tetrahedral mesh using a Gaussian quadrature
// James Liu, ColoState; 2014/07--2016/05

// #include "vector.h"

#include "cell3d.h"
#include "GaussQuad.h"
#include "mat3.h"
#include "PtVec3d.h"
#include "TetraMesh.h"

// JL20150522: TO BE REVISED, now temporarily "using" 1-point Gaussian quadraure

int Darcy3d_SmplnPerm_TetraMesh(Mat3 *PermK, Mat3 (*fxnMatK)(PtVec3d pt),
                                const TetraMesh &mesh, const GaussQuad &GQTe)
{
  int ie;
  // double x, y, z;
  Tetra tetra;
  PtVec3d cntr;
  Mat3 MatK;

  // Setup
  for (ie=0; ie<mesh.endLabelElement(); ++ie) {
    tetra = mesh.element(ie+1);
    cntr = tetra.center();
    // x = cntr.xCrd();
    // y = cntr.yCrd();
    // z = cntr.zCrd();
    MatK = fxnMatK(cntr);
    PermK[ie] = MatK;
  }

  return(0);  // if successful
}

// Darcy3d_SmplnPerm_TetraMesh.cpp